import json, urllib2, base64
lon=-0.1203
lat=51.5013

	
def get_position(lat, lon):
	username = 'e855fbf93a12d2d0f8651d8388e5d700'
	password = ''

	url='http://itracs-project.org/api/7c60e7f4-20ff-11e3-857c-fcfb53959281/bus/stops/near.json?lon='+str(lon)+'&lat='+str(lat)+'&page=1&rpp=10'

	trim_url = 'http://itracs-project.org/'

	# print url

	request = urllib2.Request(url)
	base64string = base64.encodestring('%s:%s' % (username, password)).replace('\n', '')
	request.add_header("Authorization", "Basic %s" % base64string)

	r=urllib2.urlopen(request)
	json_string=r.read()
	nearby_stations=json.loads(json_string)

	return nearby_stations['stops'][0]['atcocode']


# ==========================================================================================
# ==========================================================================================
# ==========================================================================================

import itertools
import numpy
from random import randint
	
def TSP(n, dictDistance):
	number = numpy.arange(n)

	map1=itertools.combinations(number,2)
	map2 = numpy.array(list(map1))

	dictResults = {}
	results = itertools.permutations(number,n)
	x = numpy.array(list(results))
	a = len(x)/n
	x = x [:a]

	for any in x:
		dictResults[tuple(any)] = 0
		i=0
		while i < n-1:
			s = (any[i], any[i+1])
			# print s
			s1 = (any[i+1], any[i])
			# print s1
			if s in dictDistance:
				
				dictResults[tuple(any)] += dictDistance[s]
				
			elif s1 in dictDistance:
				
				dictResults[tuple(any)] += dictDistance[s1]
				
			else:
				print 'error: the key is not found'
			i = i + 1
	# print dictResults
	min = 1000000
	for any in dictResults.keys():
		if(min > dictResults[any]):
			min = dictResults[any]
			min_item = any
			
	return (min, min_item)

##########################################
import csv
from collections import defaultdict
from heapq import *
 
 
def dijkstra(edges, f, t):
	g = defaultdict(list)
	for l,r,c in edges:
			g[l].append((c,r))

	q, seen = [(0,f,())], set()
	while q:
			(cost,v1,path) = heappop(q)
			if v1 not in seen:
					seen.add(v1)
					path = (v1, path)
					if v1 == t: return (cost, path)

					for c, v2 in g.get(v1, ()):
							if v2 not in seen:
									heappush(q, (cost+c, v2, path))

	return float("inf")

class Graph:
	def __init__(self):
		self.nodes = set()
		self.edges = []
		# self.edges = defaultdict(list)
		self.distances = {}
 
	def add_node(self, value):
		self.nodes.add(value)
 
	# def add_edge(self, from_node, to_node):
	def add_edge(self, from_node, to_node, distance):
		self.edges.append( (from_node, to_node, distance) )


transport = Graph()
data = []

with open('timetable.csv', 'rb') as csvfile:
	reader = csv.reader(csvfile, delimiter=',', quotechar='\"')
	for row in reader:
			data.append(row);

for i in range(len(data) - 1):
	row1 = data[i]
	row2 = data[i + 1]
	line_no1 = row1[0]
	line_no2 = row2[0]
	stop1 = row1[5].strip()
	stop2 = row2[5].strip()
	# print stop1

	if (line_no1 == line_no2):
		transport.add_edge(stop1, stop2, 1)

# print transport.edges
# print dijkstra( transport.edges, '490000235Z', '490003261E')

# tree = {
#         'A': [('B', 10), ('C', 3)],
#         'B': [('C', 3), ('D', 4)],
#         'C': [('D', 2)],
#         'D': [('E', 10)]
#     }
# print dijkstra(tree, 'A', 'D')

# tree = defaultdict(list)

# tree['A'] = [('B', 10), ('C', 3)]
# tree['B'] = [('C', 3), ('D', 4)]
# tree['C'] = [('D', 2)]
# tree['D'] = [('E', 10)]

# print dijkstra(tree, 'A', 'D')

def flatten(container):
    for i in container:
        if isinstance(i, list) or isinstance(i, tuple):
            for j in flatten(i):
                yield j
        else:
            yield i

def listit(t):
    return list(map(listit, t)) if isinstance(t, (list, tuple)) else t

def get_route(start, end):
	start_stop = get_position(start[0], start[1])
	end_stop = []
	end_stop.append(start_stop)
	for x in end:
		end_stop.append(get_position(x[0], x[1]))
	print end_stop

	d = {}
	r = {}
	l = len(end_stop)
	for i in range(l):
		for j in range(i+1, l):
			dist, route = dijkstra(transport.edges, end_stop[i], end_stop[j])
			tmp = list(flatten(listit(route)))
			print tmp
			r[ (i, j) ] = tmp
			d[ (i, j) ] = dist

	print d
	m, rt = TSP(l,d)
	obj = {}
	obj['min'] = m
	obj['route'] = rt

	droute = []
	for i in range(len(rt) - 1):
		# print (rt[i], rt[i+1])
		if (rt[i], rt[i+1]) in r:
			droute.append(r[ (rt[i], rt[i+1]) ])
		elif (rt[i+1], rt[i]) in r:
			droute.append(r[ (rt[i+1], rt[i]) ])
	obj['detailed_route'] = droute

	return obj


# get_route( (lat, lon), [ (51.3,-0.12), (51.55, -0.128) ])
# http://localhost:8080/?startlat=51.5013&startlon=-0.1203&endlat=51.3&endlon=-0.12&endlat=51.55&endlon=-0.128

from BaseHTTPServer import BaseHTTPRequestHandler
import urlparse
import json

class GetHandler(BaseHTTPRequestHandler):
    
    def do_GET(self):
        parsed_path = urlparse.urlparse(self.path)
        message_parts = [
                'CLIENT VALUES:',
                'client_address=%s (%s)' % (self.client_address,
                                            self.address_string()),
                'command=%s' % self.command,
                'path=%s' % self.path,
                'real path=%s' % parsed_path.path,
                'query=%s' % parsed_path.query,
                'request_version=%s' % self.request_version,
                '',
                'SERVER VALUES:',
                'server_version=%s' % self.server_version,
                'sys_version=%s' % self.sys_version,
                'protocol_version=%s' % self.protocol_version,
                '',
                'HEADERS RECEIVED:',
                ]
        for name, value in sorted(self.headers.items()):
            message_parts.append('%s=%s' % (name, value.rstrip()))
        message_parts.append('')
        message = '\r\n'.join(message_parts)
        message = ''

        ########################

        # message = cgi.parse_qs(parsed_path.query)
        d = urlparse.parse_qs(parsed_path.query)

        startlat = d['startlat'][0]
        startlon = d['startlon'][0]

        start  = (startlat, startlon)

        end = [(i, j) for i,j in zip(d['endlat'], d['endlon'])]

        route = get_route(start, end)

        message = json.dumps(route)

        ########################

        self.send_response(200)
        self.send_header('Access-Control-Allow-Origin', '*')
        self.end_headers()
        self.wfile.write(message)
        # print cgi.parse_qs(parsed_path.query)
        return

if __name__ == '__main__':
    from BaseHTTPServer import HTTPServer
    server = HTTPServer(('localhost', 8080), GetHandler)
    print 'Starting server, use <Ctrl-C> to stop'
    server.serve_forever()
